///////////////////////////////////////////////////////////////////////////////
//
//   ROCKWELL SEMICONDUCTOR SYSTEMS - COMMERCIAL GPS BUSINESS
//
///////////////////////////////////////////////////////////////////////////////
//
//
//   MSG1041.C - Message 1041 Processing
// 
//
//   DESCRIPTION
//
//   Functions to decode, build, and display Zodiac 1041 messages.
//
//
//   REVISION HISTORY
//
//
//
////////////////////////////////////////////////////////////////////////////////

#include <stdio.h>
#include <string.h>

#include "gentypes.h"
#include "gencons.h"
#include "ztypes.h"
#include "zcons.h"   
#include "util.h" 
#include "display.h"
#include "eph_send.h"

void wait(float);  
void clear_message_line(void);   

////////////////////////////////////////////////////////////////////////////////
//   
//   Decode a Zodiac 1041 message from the ZMsgBuf.
//
void Dec1041(tMSGBUF *ZMsgBuf, tMSG1041 *Msg)
{
  char    Buf[80] = ""; 
  unsigned i=0;
  extern short file_len,VisSatPos[32];
  extern unsigned char filebuff[1000];
  static short Sat=0;
  
  file_len = 0;
  memset(&ZMsg.Msg1241, 0, sizeof(ZMsg.Msg1241));
  BldZMsg(ZMsgBuf, ZMsg, 1241);  
  for (i=0; i < sizeof(ZMsg.Msg1241) + HDR_LEN; i++, file_len++)
    filebuff[file_len] = (unsigned char)ZMsgBuf->byte[i];    /* Save Data To File Buffer */


  if (Msg->svid > 0 && Msg->svid < 33) {
    Sat = VisSatPos[Msg->svid-1];
    if ( Sat >= 0 ) {
      sprintf(Buf,"%4d",(Msg->raw_data[12]>>8)&0x00FF);ShowText(Buf,VISR+Sat,VISC+10);
    }
  }

  store_eph(file_len);

}                                      

